IF NOT EXISTS( SELECT * FROM SYS.columns WHERE NAME = 'FLAG_INTEGRACAO_ROBO' AND OBJECT_ID = OBJECT_ID('EST_PROD_TRANSF'))
    BEGIN
        ALTER TABLE EST_PROD_TRANSF ADD FLAG_INTEGRACAO_ROBO INT NULL DEFAULT 0;
    END;
GO

IF EXISTS(SELECT *FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_DIVIDE_ROBO]') AND TYPE IN(N'P', N'PC'))
    DROP PROCEDURE [DBO].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_DIVIDE_ROBO];


GO

CREATE PROCEDURE [DBO].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_DIVIDE_ROBO] (@CD_CTR_TRANSF INT =0 , @CD_FILIAL_PAR INT =0)

AS
SET NOCOUNT ON;
DECLARE @CD_CTR_ULT INT;
		DECLARE  @CD_EMP INT,@CD_FILIAL INT, @CD_CTR INT, @Flag Tinyint
     /**********************************************************************************************************/

     CREATE TABLE #TMP_TRANSF_CAB(CD_EMP    INT, 
											  CD_FILIAL INT, 
											  CD_CTR    INT
											 ); 

     /**********************************************************************************************************/

	 IF (@CD_CTR_TRANSF  + @CD_FILIAL_PAR> 1)
	 BEGIN
		INSERT INTO #TMP_TRANSF_CAB
		SELECT DISTINCT 
				T.CD_EMP, 
				T.CD_FILIAL, 
				T.CD_CTR
		FROM EST_PROD_TRANSF T
				JOIN EST_PROD_TRANSF_IT I ON T.CD_EMP = I.CD_EMP
											AND T.CD_FILIAL = I.CD_FILIAL
											AND T.CD_CTR = I.CD_CTR
				JOIN EST_PROD_CPL C ON I.CD_EMP = C.CD_EMP
									AND I.CD_FILIAL = C.CD_FILIAL
									AND I.CD_PROD = C.CD_PROD
				JOIN EST_PROD_PRT P ON C.CD_EMP = P.CD_EMP
									AND C.PRAT = P.CD_PRT
		WHERE T.CD_EMP = 1
				AND T.STS_TRANSF = 0
				AND P.FLAG_INTEGRACAO_ROBO = 1
				AND T.FLAG_INTEGRACAO_ROBO = 0
				AND T.CD_FILIAL = @CD_FILIAL_PAR
				AND T.CD_CTR = @CD_CTR_TRANSF 
				;
				 
	 END
	 ELSE
	 BEGIN
		INSERT INTO #TMP_TRANSF_CAB
		SELECT DISTINCT 
				T.CD_EMP, 
				T.CD_FILIAL, 
				T.CD_CTR
		FROM EST_PROD_TRANSF T
				JOIN EST_PROD_TRANSF_IT I ON T.CD_EMP = I.CD_EMP
											AND T.CD_FILIAL = I.CD_FILIAL
											AND T.CD_CTR = I.CD_CTR
				JOIN EST_PROD_CPL C ON I.CD_EMP = C.CD_EMP
									AND I.CD_FILIAL = C.CD_FILIAL
									AND I.CD_PROD = C.CD_PROD
				JOIN EST_PROD_PRT P ON C.CD_EMP = P.CD_EMP
									AND C.PRAT = P.CD_PRT
		WHERE T.CD_EMP = 1
				AND T.STS_TRANSF = 0
				AND T.TP_TRANSF = 0 --Ressuprimento automatico
				AND P.FLAG_INTEGRACAO_ROBO = 1
				AND T.FLAG_INTEGRACAO_ROBO = 0;
	END

	IF NOT EXISTS (SELECT * fROM #TMP_TRANSF_CAB )
	BEGIN
		if (@CD_CTR_TRANSF>0)
		begin
			select @CD_CTR_TRANSF CD_CTR
		end

		RETURN;
	END
	 

	/**********************************************************************************************************/
	 
	DECLARE CTRANSF CURSOR FAST_FORWARD FOR 
	SELECT CD_EMP, CD_FILIAL,CD_CTR  FROM #TMP_TRANSF_CAB
	
	OPEN CTRANSF 
	FETCH NEXT FROM CTRANSF INTO @CD_EMP,@CD_FILIAL,@CD_CTR;
	WHILE @@FETCH_STATUS=0	
		BEGIN
			begin try
				 
				--Se 100% dos produtos sao do ROBO apenas alterar a flag integrao
				if not exists(Select
								count(*)
							FROM   EST_PROD_TRANSF_IT I 
									JOIN EST_PROD_CPL C ON I.CD_EMP = C.CD_EMP
														AND I.CD_FILIAL = C.CD_FILIAL
														AND I.CD_PROD = C.CD_PROD
									JOIN EST_PROD_PRT P ON C.CD_EMP = P.CD_EMP
														AND C.PRAT = P.CD_PRT
							WHERE I.CD_EMP = @CD_EMP
									AND I.CD_FILIAL = @CD_FILIAL
									AND I.CD_CTR =@CD_CTR
									AND P.FLAG_INTEGRACAO_ROBO = 0) 
				begin
					UPDATE EST_PROD_TRANSF 
					SET  FLAG_INTEGRACAO_ROBO = 1 
					where  CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_CTR = @CD_CTR;				
				end
				else
				begin
				
					UPDATE EST_PROD_TRANSF 
					SET  STS_TRANSF = 4 , OBSERVACAO ='CANCELADO INTEGRACAO ROBO'
					where  CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_CTR = @CD_CTR;

					Set @Flag =1

	RepeteGravacao:
					SET @CD_CTR_ULT = ISNULL((SELECT MAX(CD_CTR) FROM  EST_PROD_TRANSF T WITH (NOLOCK)
													WHERE T.CD_EMP=1 
															AND T.CD_FILIAL = @CD_FILIAL),0) + 1; 

					insert into EST_PROD_TRANSF (CD_EMP			,CD_FILIAL			,CD_CTR
												,TP_TRANSF			,CD_FIL_ORIG			,CD_FIL_DEST
												,DT_TRANSF			,DT_ENTR
												,STS_TRANSF			,DT_CAD
												,CD_USU			,DT_ULT_ATU			,QTDE_VOLUMES
												,FLAG_CAIXA_FECHADA			,FLAG_CHECKOUT_INICIADO
												,FLAG_QTDE_CHECKOUT			,HR_TRANSF
												,TP_REQ_TRANSF			,RESSUP_DIVIDO
												,OBSERVACAO			,AJUSTADO
												,CD_AGD_RESSUP			,UUID
												,FLAG_INTEGRACAO_ROBO)
						SELECT 
							CD_EMP
							,CD_FILIAL
							,@CD_CTR_ULT  
							,TP_TRANSF
							,CD_FIL_ORIG
							,CD_FIL_DEST
							,DT_TRANSF
							,DT_ENTR
							,0 STS_TRANSF
							,DT_CAD
							,CD_USU
							,DT_ULT_ATU
							,QTDE_VOLUMES
							,FLAG_CAIXA_FECHADA
							,FLAG_CHECKOUT_INICIADO
							,FLAG_QTDE_CHECKOUT
							,HR_TRANSF
							,TP_REQ_TRANSF
							,RESSUP_DIVIDO
							,'Ressup Origem: ' + CONVERT(VARCHAR(10), @CD_CTR)  OBSERVACAO
							,1 AJUSTADO
							,CD_AGD_RESSUP
							,UUID
							,@Flag FLAG_INTEGRACAO_ROBO
						FROM 
							EST_PROD_TRANSF
						WHERE
							CD_EMP= @CD_EMP
							AND CD_CTR=@CD_CTR
							AND CD_FILIAL =@CD_FILIAL;
				 
					INSERT INTO EST_PROD_TRANSF_IT (CD_EMP,CD_FILIAL,CD_CTR,CD_PROD,QT_SOL,QT_AT,VLR_CUSTO,QT_EST_RES,QT_MEDIAF
						,QT_EMAX,QT_ESEG,FLAG_RATEIO,QT_EST_DEPO_RES,PERC_RATEIO,PERC_DESC,QT_EST,QT_PEND_ENT,EMAX_RES
						,ESEG_RES,VLR_CUSTO_MD,VLR_CUSTO_ACERTO,QT_UNI_RESSUPRIMENTO,QT_NECESSIDADE,TP_PRECO,ALIQ_ICMS_ENTRADA,VLR_CUSTO_PROD_ORIG,PARAM_ADD_AGENDA
						,QT_SOL_ENCOMENDA,FLAG_LIMPAR_SALDO)
					SELECT 
						 I.CD_EMP
						,I.CD_FILIAL
						,@CD_CTR_ULT CD_CTR
						,I.CD_PROD
						,I.QT_SOL
						,I.QT_AT
						,I.VLR_CUSTO
						,I.QT_EST_RES
						,I.QT_MEDIAF
						,I.QT_EMAX
						,I.QT_ESEG
						,I.FLAG_RATEIO
						,I.QT_EST_DEPO_RES
						,I.PERC_RATEIO
						,I.PERC_DESC
						,I.QT_EST
						,I.QT_PEND_ENT
						,I.EMAX_RES
						,I.ESEG_RES
						,I.VLR_CUSTO_MD
						,I.VLR_CUSTO_ACERTO
						,I.QT_UNI_RESSUPRIMENTO
						,I.QT_NECESSIDADE
						,I.TP_PRECO
						,I.ALIQ_ICMS_ENTRADA
						,I.VLR_CUSTO_PROD_ORIG
						,I.PARAM_ADD_AGENDA
						,I.QT_SOL_ENCOMENDA
						,I.FLAG_LIMPAR_SALDO
					FROM   EST_PROD_TRANSF_IT I 
							JOIN EST_PROD_CPL C ON I.CD_EMP = C.CD_EMP
												AND I.CD_FILIAL = C.CD_FILIAL
												AND I.CD_PROD = C.CD_PROD
							JOIN EST_PROD_PRT P ON C.CD_EMP = P.CD_EMP
												AND C.PRAT = P.CD_PRT
					WHERE I.CD_EMP = @CD_EMP
							AND I.CD_FILIAL = @CD_FILIAL
							AND I.CD_CTR =@CD_CTR
							AND P.FLAG_INTEGRACAO_ROBO = @Flag;
					-----------------------------------------------------------------------------------------------------------------------
				
					if @Flag=1 and exists( Select *
											FROM   EST_PROD_TRANSF_IT I 
													JOIN EST_PROD_CPL C ON I.CD_EMP = C.CD_EMP
																		AND I.CD_FILIAL = C.CD_FILIAL
																		AND I.CD_PROD = C.CD_PROD
													JOIN EST_PROD_PRT P ON C.CD_EMP = P.CD_EMP
																		AND C.PRAT = P.CD_PRT
											WHERE I.CD_EMP = @CD_EMP
													AND I.CD_FILIAL = @CD_FILIAL
													AND I.CD_CTR =@CD_CTR
													AND P.FLAG_INTEGRACAO_ROBO =0)
					begin
						Set @Flag=0
						goto RepeteGravacao --Grava o restante dos itens que nao sao de integracao c o Robo
					end
				end
				end try
				begin catch
					--Devolve o status em caso de erro
					UPDATE EST_PROD_TRANSF
					SET STS_TRANSF =0
					WHERE
						CD_EMP=@CD_EMP
						AND CD_FILIAL =@CD_FILIAL 
						AND CD_CTR = @CD_CTR;

					if ERROR_NUMBER() =2627
						print 'Falha ao buscar o codigo transferencia'

				end catch
			  
					
			FETCH NEXT FROM CTRANSF INTO @CD_EMP,@CD_FILIAL,@CD_CTR; 
		END 
		 
		CLOSE CTRANSF;		
		DEALLOCATE CTRANSF;

	if (@CD_CTR_TRANSF>0)
	begin
		select @CD_CTR_ULT CD_CTR
	end